define([
    'underscore',
    'marionette',
    'modules/appointments/appointments-module',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-month-collection',

    'text!modules/new-appointment-request/views/direct/preferred-date/templates/all-dates.html',
    'modules/new-appointment-request/views/direct/preferred-date/month-collapsible',
    'modules/new-appointment-request/views/direct/preferred-date/switch-to-request-popup',
    'moment',
],
function(
    _,
    Marionette,
    module,
    TimeSlotsByMonthCollection,

    template,
    MonthCollapsibleView,
    SwitchToRequestPopupView,
    moment
) {
    'use strict';

    // given this.timeSlotsByDateCollection and this.model (form model),
    // create this.collection filtered by month and show child views
    return Marionette.CompositeView.extend({
        tagName: 'fieldset',
        className: 'available-dates-times-collapsibles',
        template: template,
        childView: MonthCollapsibleView,
        childViewContainer: '#all-available-dates-container',
        events: {'click #no-date-time-that-works': 'viewNoDateTimeThatWorks'},

        initialize: function(options) {
            this.timeSlotsByDateCollection = options.timeSlotsByDateCollection;
            if (_.isUndefined(this.collection)) {
                // create collection of available dates, filtered by month
                this.collection = new TimeSlotsByMonthCollection(null, {
                    fromTimeSlotsByDateCollection: this.timeSlotsByDateCollection,
                });
            }
        },
        onDomRefresh: function() {
            this.$el.trigger('create');
            this.focusOnLegend();
            this.expandPreferredDate(this.model.get('desiredDate'));
        },
        focusOnLegend: function() {
            // iOS Safari unable to focus on legend, focusing on text in legend instead
            this.$el.find('legend span[tabindex]').focus();
        },

        _expandPreferredDate: function(desiredDate, preferredDateString) {
            var date = new Date(desiredDate);
            var dateString = moment(date).format('MMMM-YYYY');
            var monthId = dateString.toLowerCase();
            var monthModel = this.collection.get(monthId);

            // TODO These ternaries probably are not needed at all
            var monthView = monthModel ? this.children.findByModel(monthModel) : undefined;
            var dateModel = monthView ? monthView.collection.get(preferredDateString) : undefined;
            var dateView = dateModel ? monthView.children.findByModel(dateModel) : undefined;

            if (!_.isUndefined(monthView) && !_.isUndefined(dateView)) {
                dateView.$el.collapsible('expand');
            }
        },
        expandPreferredDate: function(desiredDate) {
            var dateLength = 10;
            var preferredDateString = desiredDate.substring(0, dateLength);

            if (!this.isDestroyed() && !_.isUndefined(preferredDateString)) {
                this._expandPreferredDate(desiredDate, preferredDateString);
            }
        },
        hasPreferredDate: function(desiredDate) {
            var dateLength = 10;
            return this.timeSlotsByDateCollection.hasDate(desiredDate.substring(0, dateLength));
        },
        templateContext: function() {
            var hasPreferredDate = this.hasPreferredDate(this.model.get('desiredDate'));


            return {hasPreferredDate: hasPreferredDate};
        },
        viewNoDateTimeThatWorks: function(e) {
            var modal;

            e.preventDefault();

            modal = new SwitchToRequestPopupView({
                elAfterClose: e.currentTarget,
                customMessage: this.options.customMessage,
            });
            modal.openPopup();
        },
    });
});
